<?php
/* --------------------------------------------------------------
  ConfigInterface.inc.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace StyleEdit\Entities\Interfaces;

use \DateTime;
use \InvalidArgumentException;

/**
 * Interface ConfigInterface
 * 
 * @package StyleEdit\Entities\Interfaces
 */
interface ConfigInterface
{
	/**
	 * Returns the name of the style configuration
	 *
	 * @return string
	 */
	public function getName();
	
	
	/**
	 * Returns the boilerplate's filename of the style configuration
	 *
	 * @return string
	 */
	public function getBoilerplateName();
	
	
	/**
	 * Returns the creation date of the style configuration as a DateTime object
	 *
	 * @return \DateTime
	 */
	public function getCreationDate();
	
	
	/**
	 * Returns the modification date of the style configuration as a DateTime object
	 *
	 * @return \DateTime
	 */
	public function getModificationDate();
	
	
	/**
	 * Returns the boilerplate modification date of the style configuration as a DateTime object
	 *
	 * @return \DateTime
	 */
	public function getBoilerplateModificationDate();
	
	
	/**
	 * Returns the complete configuration as an array
	 *
	 * @return array
	 */
	public function getJsonDataArray();
	
	
	/**
	 * Updates the style configuration name
	 *
	 * @throws \InvalidArgumentException if $p_name is not a string
	 *
	 * @param string $p_name
	 *
	 * @return \StyleEdit\Entities\Interfaces\ConfigInterface Same instance to make chained method calls possible.
	 */
	public function setName($p_name);
	
	
	/**
	 * Updates the creation date of the style configuration
	 *
	 * @param DateTime $dateTime
	 *
	 * @return \StyleEdit\Entities\Interfaces\ConfigInterface Same instance to make chained method calls possible.
	 */
	public function setCreationDate(DateTime $dateTime);
	
	
	/**
	 * Updates the modification date of the style configuration
	 *
	 * @param DateTime $dateTime
	 *
	 * @return \StyleEdit\Entities\Interfaces\ConfigInterface Same instance to make chained method calls possible.
	 */
	public function setModificationDate(DateTime $dateTime);
	
	
	/**
	 * Updates the boilerplate modification date of the style configuration
	 *
	 * @param DateTime $dateTime
	 *
	 * @return \StyleEdit\Entities\Interfaces\ConfigInterface Same instance to make chained method calls possible.
	 */
	public function setBoilerplateModificationDate(DateTime $dateTime);
}